#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>

int main(int argc, char **argv)
{
    char cmd[128];
    int fd; void *addr;
    int pagesize = getpagesize();

    /* use a readable file */
    fd = open("/dev/zero", O_RDONLY);
    if (fd < 0) exit(1);

    /* map at any address */
    addr = mmap(0, 10*pagesize, PROT_READ,
		MAP_PRIVATE, fd, 0);
    printf("mapped /dev/zero at %p\n", addr);

    /* map it again at a chosen address (2G) */
    addr = mmap((void *)(2<<30), 10*pagesize, PROT_READ,
		MAP_PRIVATE | MAP_FIXED, fd, 0);
    printf("mapped /dev/zero at %p\n", addr);
    close(fd);

    /* map anonymous memory */
    addr = mmap(0, 10*pagesize, PROT_READ | PROT_WRITE | PROT_EXEC,
		MAP_PRIVATE | MAP_ANONYMOUS, 0, 0);
    printf("mapped anonymous at %p\n", addr);

    /* show our map, lazily */
    sprintf(cmd, "cat /proc/%i/maps", getpid());
    system(cmd);
    exit(0);
}
