#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <linux/fb.h>

struct fb_var_screeninfo var;
struct fb_fix_screeninfo fix;

int main(int argc, char **argv)
{
    int i, j, x, y, z;
    int fd;
    char head[256]="";
    char s[80];
    unsigned char pix[3];
    unsigned char *addr;
    int usemmap = (int)getenv("USEMMAP");

    if (argc > 1) exit(1);

    while(1) {
	/* parse ppm header */
        if (!fgets(s, 80, stdin)) exit(2);
        if (s[0] == '#') continue;
        if (strlen(head) + strlen(s) > 255) exit(3);
        strcat(head, s);
        if (head[0]!='P' || head[1]!='6') exit(4);
        if (sscanf(head, "P6 %i %i %i", &x, &y, &z) == 3)
            break;
    }

    fd = open("/dev/fb0", O_RDWR);
    if (fd < 0) exit(5);

    if (ioctl(fd, FBIOGET_VSCREENINFO, &var)) exit(6);
    if (ioctl(fd, FBIOGET_FSCREENINFO, &fix)) exit(7);

    addr = mmap(0, fix.line_length * var.yres, PROT_WRITE, MAP_SHARED, fd, 0);
    if (addr == (unsigned char *)-1) exit(8);

    for (j=0; j<y; j++) {
	unsigned short thispix;
	for (i=0; i<x; i++) {
	    int index;
	    fread(pix, 1, 3, stdin);
	    if (i >= var.xres)
		continue;
	    if (j >= var.yres)
		continue;
	    index = j * fix.line_length + i*2;
	    thispix = (((short)pix[0]<<8) & 0xf800)
		| (((short)pix[1]<<3) & 0x07e0)
		| ((short)pix[2]>>3);
	    if (usemmap) {
		*(unsigned short *)(addr + index) = thispix;
	    } else {
		lseek(fd, index, SEEK_SET);
		write (fd, &thispix, 2);
	    }
	}
    }
    exit(0);
}    


