#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <linux/fb.h>

struct fb_var_screeninfo var;
struct fb_fix_screeninfo fix;

int main(int argc, char **argv)
{
    int i, j, x, y;
    int fd;
    unsigned char *addr;
    int usemmap = (int)getenv("USEMMAP");

    if (argc > 1) exit(1);

    fd = open("/dev/fb0", O_RDWR);
    if (fd < 0) exit(2);

    if (ioctl(fd, FBIOGET_VSCREENINFO, &var)) exit(3);
    if (ioctl(fd, FBIOGET_FSCREENINFO, &fix)) exit(4);

    addr = mmap(0, fix.line_length * var.yres, PROT_WRITE, MAP_SHARED, fd, 0);
    if (addr == (unsigned char *)-1) exit(5);

    x = var.xres; y = var.yres;
    printf("P6\n%i %i \n255\n", x, y);

    for (j=0; j<y; j++) {
	unsigned short thispix;
	for (i=0; i<x; i++) {
	    int index;
	    index = j * fix.line_length + i*2;
	    if (usemmap) {
		thispix = *(unsigned short *)(addr + index);
	    } else {
		lseek(fd, index, SEEK_SET);
		read (fd, &thispix, 2);
	    }
	    putchar((thispix & 0xf800) >> 8);
	    putchar((thispix & 0x07e0) >> 3);
	    putchar((thispix & 0x001f) << 3);
	}
    }
    exit(0);
}    


