#if 1
/* should that be cap_setpcap+ip? */
#define INIT_CAPS "=eip cap_setpcap+eip"
#define INIT_PATH "/sbin/init"
#else
#define INIT_CAPS "all=pi cap_fowner=pi cap_setpcap+eip"
#define INIT_PATH "/bin/ls"
#endif

#include <stdio.h>
#include <unistd.h>
/* avoids some bogus warnings */
#define _LINUX_FS_H
#include <sys/capability.h>

int main(int argc, char *argv[])
{
    int i;
    cap_t new_caps;

    if ((new_caps = cap_from_text(INIT_CAPS)) == NULL)
	fprintf(stderr, "initcaps: cap_from_text()failed. "
		"Cannot set requested capabilities.\n");
    else if (cap_set_proc(new_caps) != 0)
	perror("initcaps: unable to set capabilities");

    /* start init */
    argv[0] = INIT_PATH;
    printf("[*] initcaps: starting");
    for (i = 0; i != argc; i++)
	printf(" %s", argv[i]);
    printf("\n");
    execv(*argv, argv);

    /* if we fall through to here, our exec failed -- announce the fact */
    perror("initcaps: unable to execute " INIT_PATH);
    exit(1);
}
